/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCore;
import filenet.vw.apps.designer.VWDesignerDocumentHelper;
import filenet.vw.apps.designer.VWFileContext;
import filenet.vw.apps.designer.VWSolutionHelper;
import filenet.vw.apps.designer.VWWorkflowCollectionPropertiesDialog;
import filenet.vw.base.CEObjectInfoCache;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.canvas.VWDesignerTabbedCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.VWProcessMenuHelper;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioMenuHelper;
import filenet.vw.toolkit.design.mapui.VWDesignerMapAttribs;
import filenet.vw.toolkit.design.palette.VWStepPaletteDocumentHelper;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.event.VWCoordinationEventNotifier;
import filenet.vw.toolkit.utils.VWDataDictionary;
import filenet.vw.toolkit.utils.VWOpenItem;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JPanel;

public class VWDesignerCoreData {
    public static final int MODE_DIAGRAM = 0;
    public static final int MODE_DESIGN = 1;
    private VWDesignerTabbedCanvasPanel m_tabbedCanvasPanel = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWDesignerDocumentHelper m_designerDocumentHelper = null;
    private VWSolutionHelper m_solutionHelper = null;
    private VWDesignerPreferences m_designerPreferences = null;
    private VWDesignerMapAttribs m_designerMapAttribs = null;
    private VWStepPaletteDocumentHelper m_stepPaletteDocumentHelper = null;
    private VWCoordinationEventNotifier m_coordinationEventNotifier = null;
    private VWDataDictionary m_dataDictionary = null;
    private VWFileContext m_fileContext = null;
    private VWProcessMenuHelper m_processMenuHelper = null;
    private VWWorkflowCollectionPropertiesDialog m_propertiesDialog = null;
    private VWScenarioMenuHelper m_scenarioMenuHelper = null;
    private int m_nApplicationMode = 1;
    private String m_clipboardItems = null;

    protected VWDesignerCoreData(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_fileContext = new VWFileContext(sessionInfo.getParentFrame());
    }

    public VWDesignerDocumentHelper getDesignerDocumentHelper() {
        if (this.m_solutionHelper == null && this.m_designerDocumentHelper == null) {
            this.m_designerDocumentHelper = new VWDesignerDocumentHelper(this);
        }
        return this.m_designerDocumentHelper;
    }

    public VWSolutionHelper getSolutionHelper() {
        return this.m_solutionHelper;
    }

    public VWDesignerPreferences getDesignerPreferences() {
        if (this.m_designerPreferences == null) {
            this.m_designerPreferences = new VWDesignerPreferences(this);
            this.m_designerPreferences.initPreferenceSettings();
        }
        return this.m_designerPreferences;
    }

    public VWMapAttribs getMapAttributes() {
        if (this.m_designerMapAttribs == null) {
            this.m_designerMapAttribs = new VWDesignerMapAttribs(this);
        }
        return this.m_designerMapAttribs;
    }

    public VWOpenItem getOpenItem() {
        if (this.m_sessionInfo != null) {
            return new VWOpenItem(this.m_sessionInfo);
        }
        return null;
    }

    public VWStepPaletteDocumentHelper getStepPaletteDocumentHelper() {
        if (this.m_stepPaletteDocumentHelper == null) {
            this.m_stepPaletteDocumentHelper = new VWStepPaletteDocumentHelper(this);
        }
        return this.m_stepPaletteDocumentHelper;
    }

    public VWStepPaletteWrapper getDiagramStepPalette() {
        VWStepPaletteDocumentHelper documentHelper = this.getStepPaletteDocumentHelper();
        if (documentHelper != null) {
            return documentHelper.getDiagramStepPalette();
        }
        return null;
    }

    public VWCoordinationEventNotifier getCoordinationEventNotifier() {
        if (this.m_coordinationEventNotifier == null) {
            this.m_coordinationEventNotifier = new VWCoordinationEventNotifier();
        }
        return this.m_coordinationEventNotifier;
    }

    public VWDataDictionary getDataDictionary() {
        if (this.m_dataDictionary == null) {
            this.m_dataDictionary = new VWDataDictionary(this.m_sessionInfo);
        }
        return this.m_dataDictionary;
    }

    public CEObjectInfoCache getCEObjectInfoCache() throws VWException {
        VWSolutionHelper solutionHelper = this.getSolutionHelper();
        if (solutionHelper != null) {
            return solutionHelper.getCEObjectInfoCache(this.getDataDictionary());
        }
        VWDesignerDocumentHelper documentHelper = this.getDesignerDocumentHelper();
        if (documentHelper != null) {
            return documentHelper.getCEObjectInfoCache(this.getDataDictionary());
        }
        return null;
    }

    public Frame getParentFrame() {
        if (this.m_sessionInfo != null) {
            return this.m_sessionInfo.getParentFrame();
        }
        return null;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public void displayWaitCursor() {
        this.m_sessionInfo.getParentRootPane().setCursor(Cursor.getPredefinedCursor(3));
    }

    public void restoreDefaultCursor() {
        this.m_sessionInfo.getParentRootPane().setCursor(Cursor.getDefaultCursor());
    }

    public VWProcessMenuHelper getProcessMenuHelper() {
        if (this.m_processMenuHelper == null) {
            this.m_processMenuHelper = new VWProcessMenuHelper(this);
        }
        return this.m_processMenuHelper;
    }

    public VWScenarioMenuHelper getScenarioMenuHelper() {
        if (this.m_scenarioMenuHelper == null) {
            this.m_scenarioMenuHelper = new VWScenarioMenuHelper(this);
        }
        return this.m_scenarioMenuHelper;
    }

    public VWWorkflowDefinition fetchBaseWorkflowDefinition(VWWorkflowDefinition childWflDef) {
        if (childWflDef == null || childWflDef.getBaseWorkClassName() == null) {
            return null;
        }
        VWWorkflowDefinition baseWflDef = null;
        String baseWorkClassName = childWflDef.getBaseWorkClassName();
        try {
            baseWflDef = VWClassFactory.VWWorkflowDefinition_getBaseWorkflowDefinition(this.m_sessionInfo.getSession(), childWflDef, 234L);
            if (baseWflDef != null) {
                baseWflDef.setName(baseWorkClassName);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String errorMsg = null;
            errorMsg = VWStringUtils.compare(baseWorkClassName, "WorkObjectEx") == 0 ? VWResource.s_errorRetrievingBaseWorkflow.toString(ex.getLocalizedMessage()) : (ex.getLocalizedMessage() != null ? VWResource.s_errorLoadingBaseWorkClass.toString(baseWorkClassName, ex.getLocalizedMessage()) : VWResource.s_errorLoadingBaseWorkClass.toString(baseWorkClassName, ""));
            VWMessageDialog.showOptionDialog(this.getParentFrame(), errorMsg, 1);
        }
        return baseWflDef;
    }

    public int getApplicationMode() {
        return this.m_nApplicationMode;
    }

    public void setApplicationMode(int nNewMode) {
        switch (nNewMode) {
            case 0: 
            case 1: {
                this.m_nApplicationMode = nNewMode;
            }
        }
    }

    public boolean getHasItemsInClipboard() {
        return this.m_clipboardItems != null;
    }

    public String getClipboardItems() {
        return this.m_clipboardItems;
    }

    public void setClipboardItems(String xmlString) {
        this.m_clipboardItems = xmlString;
    }

    public VWFileContext getFileContext() {
        return this.m_fileContext;
    }

    protected JPanel getMainPanel(VWDesignerCore designerCore) {
        try {
            if (this.m_tabbedCanvasPanel == null) {
                this.m_tabbedCanvasPanel = new VWDesignerTabbedCanvasPanel();
                this.m_tabbedCanvasPanel.init(this);
            }
        }
        catch (Exception ex) {
            VWDebug.logError(ex.getLocalizedMessage());
        }
        return this.m_tabbedCanvasPanel;
    }

    protected VWDesignerTabbedCanvasPanel getTabbedCanvasPanel() {
        return this.m_tabbedCanvasPanel;
    }

    protected void stopEditing() {
        if (this.getTabbedCanvasPanel() != null) {
            this.getTabbedCanvasPanel().stopEditing();
        }
    }

    protected boolean isOkayToExit() {
        boolean bOkayToExit = true;
        VWSolutionHelper solutionHelper = this.getSolutionHelper();
        bOkayToExit = solutionHelper != null ? solutionHelper.performCloseAction(true) : this.getDesignerDocumentHelper().saveExistingDefinition(null);
        if (!bOkayToExit) {
            return bOkayToExit;
        }
        if (this.getTabbedCanvasPanel() != null) {
            return this.getTabbedCanvasPanel().isOkayToExit();
        }
        return true;
    }

    protected void notifyDocumentStateChanged(VWCoordinationEvent coordinationEvent, boolean bClearDirtyFlag) {
        this.m_coordinationEventNotifier.sendCoordinationEvent(coordinationEvent);
        if (bClearDirtyFlag) {
            this.m_processMenuHelper.clearCollectionDirtyFlag();
        }
    }

    protected void displayPackageProperties() {
        if (this.m_propertiesDialog == null) {
            this.m_propertiesDialog = new VWWorkflowCollectionPropertiesDialog(this);
        }
        this.m_propertiesDialog.reinitialize(this.m_processMenuHelper.getWorkflowCollectionDefinition());
        this.m_propertiesDialog.show();
        if (this.m_propertiesDialog.getHasChanged()) {
            this.getCoordinationEventNotifier().sendCoordinationEvent(this, 703, null);
        }
    }

    protected void performEditSolutionAction(String osName, String sdfVsId, String caseTypeSymbolicName, String workflowName) {
        try {
            if (this.m_solutionHelper != null) {
                throw new VWException("vw.apps.designer.VWDesignerCoreData.SolutionHelperNotNull", "The requested edit operation cannot be performed. You are already editing a Solution.");
            }
            this.m_solutionHelper = new VWSolutionHelper(this);
            if (!this.m_solutionHelper.performEditSolutionAction(osName, sdfVsId, caseTypeSymbolicName, workflowName)) {
                this.m_solutionHelper = null;
                return;
            }
            this.m_designerDocumentHelper = null;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.getParentFrame(), ex.getMessage(), 1);
        }
    }

    protected void resetDocumentHelpers() {
        if (this.m_solutionHelper != null) {
            this.m_solutionHelper = null;
            VWDesignerDocumentHelper docHelper = this.getDesignerDocumentHelper();
            docHelper.performNewItemAction();
            this.getCoordinationEventNotifier().sendCoordinationEvent(this, 758, null);
        }
    }

    protected void releaseReferences() {
        if (this.m_coordinationEventNotifier != null) {
            this.m_coordinationEventNotifier.releaseReferences();
            this.m_coordinationEventNotifier = null;
        }
        if (this.m_tabbedCanvasPanel != null) {
            this.m_tabbedCanvasPanel.releaseReferences();
            this.m_tabbedCanvasPanel = null;
        }
        this.m_propertiesDialog = null;
    }
}

